/* Generated By:JavaCC: Do not edit this line. CLLSj.java */
import java.util.*;
import java.io.*;
import java.util.logging.*;
import java.util.concurrent.*;


public class CLLSj implements CLLSjConstants {

static CLLSj parser;
static Env<ASTType> ed;
static Env<ASTType> eg;
static Env<EnvEntry> ep;
static boolean trace = false;
static int trace_level = 0;
static boolean unsafe = true;

static final ASTType CLOSETYPE = new ASTOneT();
static final ASTType WAITTYPE = new ASTBotT();
static final int MAXTRACE = 10;

public static long time = 0;
public static long elapsed = 0;

// for liveness checks
public static volatile int num_sends = 0;
public static volatile int num_recvs = 0;
public static volatile int num_affines = 0;
public static volatile int num_coaff = 0;

public static  synchronized void inc_sends (int v)
{
        num_sends += v;
}

public static  synchronized void inc_coaff (int v)
{
        num_coaff += v;
}

public static  synchronized void  inc_recvs (int v)
{
        num_recvs += v;
}

public static  synchronized void  inc_affines (int v)
{
        num_affines += v;
}


public static void clear_statistics ()
{
        num_sends = 0;
        num_recvs = 0;
        num_affines = 0;
        num_coaff = 0;
}

public static void liveness_statistics ()
{
       System.out.println("\u005cn\u005cnSTATISTICS");
       System.out.println("num_sends = "+ num_sends);
       System.out.println("num_recvs = "+ num_recvs);
       System.out.println("num_affines = "+ num_affines);
       System.out.println("num_coaff = "+ num_coaff);
}

//public static ConsoleHandler handler = new ConsoleHandler() {{setOutputStream(System.out);}};

//public static Logger logger = Logger.getLogger("ASTNode");

public static final ExecutorService threadPool = Executors.newCachedThreadPool();

static {
    try {
    System.setProperty("java.util.logging.SimpleFormatter.format", "%5$s %n");
    }
    catch (Exception e) { e.printStackTrace(System.out); }
}

public static void main(String args[]) {
    ed = new Env<ASTType>();
    eg = new Env<ASTType>();
    ep = new Env<EnvEntry>();
    FileInputStream fboot;

    //System.out.println("maximum pool size = " + ((ThreadPoolExecutor) threadPool).getMaximumPoolSize() );
    try {
     fboot = new FileInputStream("lib/init.clls");
    } catch (FileNotFoundException ex) {

    System.out.println("Cannot find lib/init.cls");
      return;
    };
    processFile(System.getProperty("user.dir"),new CLLSj(fboot), true);
    System.out.println ("CLASS-LSAM driver demo version 10.0, Jan 2025\u005cn");
    unsafe = false;
    processFile(System.getProperty("user.dir"),new CLLSj(System.in), false);
    System.exit(0);
}

public static void processFile(String path, CLLSj parser, boolean inc)
{
    while (true) {
    //ASTNode.reinit();
    //ASTType.reinit();
    if (!inc) { System.out.print("> "); }
    try {
        // ep.crawl(); 
        ASTNode n = parser.Start();
        eg = new Env<ASTType>(); // because of in place inserts during inference
        if (n == null) {  return; }
        if (n instanceof ASTTrace) {
        int lev = ((ASTTrace)n).getLevel();
        if (lev >= 0 && lev <MAXTRACE) {
        trace_level = lev;
        trace = (trace_level == 1);
             }
          } else
          if (n instanceof ASTSamL) {
                /* some code (e.g. argument-as-expressions) assume that every node has a parent,
                so we will create a dummy coclose node to serve as parent of the running process n (UNCLEAN) */
              ASTNode exp = ((ASTSamL)n).getExp();
              ASTCoClose parent = new ASTCoClose("dummy", exp);  // because of rewriting 
              exp.setanc(parent);
              exp.typecheck(ed,eg,ep);
              CLLSj.time=System.nanoTime();
              clear_statistics();

              //for (int i=0;i<20;i++)
              {
              SAM.SAMloop(parent.rhs, new Env<SessionField>(),ep);
              }
              while(((ThreadPoolExecutor)threadPool).getActiveCount() > 0) {
              //
              //System.out.println("MaxThreads = " +
              //((ThreadPoolExecutor)threadPool).getActiveCount());
              //liveness_statistics();
              //Thread.sleep(1);
              //
              }
              if (trace_level > 0) {
              System.out.println("ThrTime="+(System.nanoTime()-CLLSj.time));
              System.out.println("MaxThreads = " +
              ((ThreadPoolExecutor)threadPool).getActiveCount());
              }
              if (// true ||
              trace_level == 3) {
              SessionRecord.dumpStats();
              SessionRecord.clearStats();
              }
              } else
              if (n instanceof ASTInclude) {
              String fd = ((ASTInclude)n).getFn();
              //System.out.println("FD="+fd);
              //System.out.println("PATH="+path);
              String fn = path+"/"+fd;
              String newpath = fn.substring(0,fn.lastIndexOf("/"));
              //System.out.println("NEWPATH="+newpath);
              InputStream f = new FileInputStream(fn);
              System.out.println("> including "+fn);
              processFile(newpath, new CLLSj(f), true); // this should return on error
              f.close();
              if (!unsafe)
              System.out.println("included "+fn);
          }
          else {
       //  n.typecheck(ed,eg,ep);
           if (n instanceof ASTDList) {
              ASTDList ld = (ASTDList)n;
               ld.typecheckmany(ed,eg,ep);
               ep = ld.definemany(ed,eg,ep);
               //  n.typecheck(ed,eg,ep); // recursion !
               //  ep=ep.assoc(td.id,new TypeDefEntry(td));
               //  if (!unsafe) System.out.println ("Type "+td.id+": defined.");
           } else
           if (n instanceof ASTTypeDef) {
              ASTTypeDef td = (ASTTypeDef)n;
              n.typecheck(ed,eg,ep); // recursion !
              ep=ep.assoc(td.id,new TypeDefEntry(td));
           if (!unsafe)
              System.out.println ("Type "+td.id+": defined.");
           } else
           if (n instanceof ASTPList) {
              ASTPList ld = (ASTPList)n;
              ld.typecheckmany(ed,eg,ep);
              ep = ld.definemany(ed,eg,ep,unsafe);
              //System.out.println ("\nMain:");
              //ep.crawl();	 
           }
           else
           if (n instanceof ASTProcDef) {
                      ASTProcDef td = (ASTProcDef)n;
                      n.typecheck(ed,eg,ep);
                      ep=ep.assoc(td.id,new ProcEntry(td));
                      td.setEnv(ep);
                      if (!unsafe)
                        System.out.println ("Process  "+td.id+": defined.");
              }
              else
              { // must be process to run

                /* some code (e.g. argument-as-expressions) assume that every node has a parent,
                so we will create a dummy coclose node to serve as parent of the running process n */
                ASTCoClose parent = new ASTCoClose("dummy", n);
                n.setanc(parent);

                n.typecheck(ed,eg,ep);
                // System.out.println("Type Checked.");

                if (n.repeat > 1) System.out.println("[RunStatus] Running process " + n.repeat + " times.");

             Logger logger = Logger.getAnonymousLogger();
             ConsoleHandler handler = new ConsoleHandler() {{setOutputStream(System.out);}};
             handler.setFormatter(new SimpleFormatter());
             logger.addHandler(handler);

             if(n.info){
                logger.setLevel(Level.INFO);
             }
             else
                logger.setLevel(Level.OFF);

                int maxThreads = 0;
                CLLSj.time = System.nanoTime();

                clear_statistics();

                while(n.repeat  > 0){
                     parent.rhs.runproc(ep, new Env<LinSession>(), new Env<Server>(), logger);
                n.repeat--;
                }

                while(((ThreadPoolExecutor)threadPool).getActiveCount() > 0)
                {
                        // Thread.sleep(1000);
                        if (CLLSj.trace) {
                        liveness_statistics();
                        System.out.println ("..."+((ThreadPoolExecutor)threadPool).getActiveCount());
                 }
                 }
                 if (CLLSj.trace) {
                 System.out.println("ThrTime="+(System.nanoTime()-CLLSj.time));
                 System.out.println("MaxThreads = " +
                 ((ThreadPoolExecutor)threadPool).getActiveCount());}
                 }
                 }
        } catch (TypeError e) {
                System.out.println ("TypeError: ("+e.msg+")");
                e.printStackTrace(System.out);
                parser.ReInit(System.in);
                }
        catch (KindError e) {
                System.out.println ("KindError: "+e.msg);
                if (inc) { return; } else {
                parser.ReInit(System.in);
                }
        } catch (SyntaxError e) {
                System.out.println (e.msg);
          e.printStackTrace(System.out);
      if (inc) {return;} else{
        parser.ReInit(System.in);
      }
        } catch (FileNotFoundException e) {
          System.out.println ("File not found: "+e.getMessage());
                if (inc) { return; } else {
                parser.ReInit(System.in);
                }
        } catch (TokenMgrError e) {
          System.out.println(e.getMessage());
                if (inc) { return; } else {
                parser.ReInit(System.in);
                }
        } catch (ParseException e) {
          System.out.println(e.getMessage());
                if (inc) { return; } else {
                parser.ReInit(System.in);
                }
        } catch (SAMError e) {
          System.out.println("SAM Error: "+e.msg);
          e.printStackTrace(System.out);
                if (inc) { return; } else {
                parser.ReInit(System.in);
                }
        } catch (RunError e) {
          System.out.println("Runtime Error: "+e.msg);
          e.printStackTrace(System.out);
                if (inc) { return; } else {
                parser.ReInit(System.in);
                }
        } catch (Exception e) {
          System.out.println ("Unexpected error: ");
          e.printStackTrace(System.out);
                if (inc) { return; } else {
                parser.ReInit(System.in);
                }
          }
      }
    }

  final public ASTNode Start() throws ParseException, Exception {
 ASTNode n;
Token c;
List<ASTTypeDef> ld;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TYPE:
      n = TypeD();
      jj_consume_token(TERM);
      break;
    case PROC:
      n = ProcD();
      jj_consume_token(TERM);
      break;
    case FOR:
    case LET:
    case LETC:
    case LETB:
    case IF:
    case PRINT:
    case PRINTLN:
    case CLLTYPE:
    case SEND:
    case RECV:
    case SENDT:
    case RECVT:
    case DISCARD:
    case USE:
    case RELEASE:
    case TAKE:
    case PUT:
    case FWD:
    case FWDB:
    case CUT:
    case CCUT:
    case MIX:
    case CMIX:
    case CASE:
    case AFFINE:
    case CELL:
    case RD:
    case WRT:
    case LOCK:
    case UNLK:
    case EMPTY:
    case CLOSE:
    case CCLOSE:
    case SHARE:
    case SSHARE:
    case SHAREL:
    case SHARER:
    case UNFOLD:
    case SLEEP:
    case CALL:
    case lab:
    case Id:
    case BANG:
    case WHY:
    case LPAR:
      n = Proc();
      jj_consume_token(TERM);
      break;
    case REPEAT:
      jj_consume_token(REPEAT);
      c = jj_consume_token(Num);
      n = Proc();
      jj_consume_token(TERM);
                                           n.repeat = Integer.parseInt(c.image);
      break;
    case SAML:
      jj_consume_token(SAML);
      n = Proc();
      jj_consume_token(TERM);
                             n  = new ASTSamL(n);
      break;
    case SAMR:
      jj_consume_token(SAMR);
      n = Proc();
      jj_consume_token(TERM);
                             n  = new ASTSam(n);
      break;
    case TRACE:
      jj_consume_token(TRACE);
      c = jj_consume_token(Num);
      jj_consume_token(TERM);
                             n  = new ASTTrace( Integer.parseInt(c.image));
      break;
    case INFO:
      jj_consume_token(INFO);
      n = Proc();
      jj_consume_token(TERM);
                               n.info = true;
      break;
    case QUIT:
      jj_consume_token(QUIT);
      jj_consume_token(TERM);
                   n = null;
      break;
    case 0:
      jj_consume_token(0);
           n = null;
      break;
    case INCLUDE:
      jj_consume_token(INCLUDE);
      c = jj_consume_token(STRING);
      jj_consume_token(TERM);
                                 n = new ASTInclude(c.image);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
 {if (true) return n;}
    throw new Error("Missing return statement in function");
  }

  final public ASTTypeDef Type1D(boolean rec, boolean corec) throws ParseException, Exception {
 ASTType p1; Token c1;
ASTTypeDef p;
    c1 = jj_consume_token(Id);
  p = new ASTTypeDef(c1.image);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAR:
      jj_consume_token(LPAR);
      ParamListt(p);
      jj_consume_token(RPAR);
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    /*  <LBRA> */
             p1 = Type();
                       p.setType(p1);
       p.setRec(rec); p.setCoRec(corec);
      {if (true) return p;}
    throw new Error("Missing return statement in function");
  }

  final public ASTNode TypeD() throws ParseException, Exception {
 ASTType p1; Token c1;
boolean rec = false;
boolean corec = false;
List<ASTTypeDef> ld = new ArrayList<ASTTypeDef>();
ASTTypeDef  p;
    jj_consume_token(TYPE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REC:
    case COREC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REC:
        jj_consume_token(REC);
               rec = true;
        break;
      case COREC:
        jj_consume_token(COREC);
                                         corec = true;
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    p = Type1D(rec,corec);
                             ld.add(p);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_1;
      }
      jj_consume_token(AND);
      p = Type1D(rec,corec);
                                    ld.add(p);
    }
      {if (true) return new ASTDList(ld, rec || corec);}
    throw new Error("Missing return statement in function");
  }

  final public void ParamListt(ASTTypeDef p) throws ParseException, Exception {
 ASTType t; Token i;
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case Id:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_2;
      }
      i = jj_consume_token(Id);
                p.addPar(i.image);
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[6] = jj_gen;
          break label_3;
        }
        jj_consume_token(COMMA);
        i = jj_consume_token(Id);
                      p.addPar(i.image);
      }
    }
  }

  final public void ArgListT(ASTIdT t) throws ParseException, Exception {
 ASTType ty;
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LINT:
      case LCOINT:
      case LBOOL:
      case LCOBOOL:
      case LSTRING:
      case LCOSTRING:
      case SEND:
      case RECV:
      case SENDT:
      case RECVT:
      case CHOICE:
      case OFFER:
      case STATE:
      case LSTATE:
      case STATEL:
      case LSTATEL:
      case USAGE:
      case LUSAGE:
      case USAGEL:
      case LUSAGEL:
      case AFFINE:
      case COAFFINE:
      case CLOSE:
      case CCLOSE:
      case Id:
      case NOT:
      case BANG:
      case WHY:
      case LBRA:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_4;
      }
      ty = Type();
                 t.addarg(ty);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[8] = jj_gen;
          break label_5;
        }
        jj_consume_token(COMMA);
        ty = Type();
                                                     t.addarg(ty);
      }
    }
  }

  final public ASTType Type() throws ParseException, Exception {
  ASTType l,r,t; Token s;
    t = SType();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TIMES:
    case IMP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMP:
        jj_consume_token(IMP);
        r = Type();
                       t = new ASTRecvT(new ASTNotT(t),r);
        break;
      case TIMES:
        jj_consume_token(TIMES);
        r = Type();
                         t = new ASTSendT(t,r);
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
     {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public ASTType SType() throws ParseException, Exception {
  ASTType l,r,t; Token s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case Id:
      s = jj_consume_token(Id);
              t = new ASTIdT(s.image);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAR:
        jj_consume_token(LPAR);
        ArgListT((ASTIdT)t);
        jj_consume_token(RPAR);
        break;
      default:
        jj_la1[11] = jj_gen;
        ;
      }
      break;
    case LINT:
      jj_consume_token(LINT);
    t = new ASTLintT();
      break;
    case LCOINT:
      jj_consume_token(LCOINT);
    t = new ASTLCointT();
      break;
    case LBOOL:
      jj_consume_token(LBOOL);
    t = new ASTLboolT();
      break;
    case LCOBOOL:
      jj_consume_token(LCOBOOL);
    t = new ASTCoLboolT();
      break;
    case LSTRING:
      jj_consume_token(LSTRING);
    t = new ASTLstringT();
      break;
    case LCOSTRING:
      jj_consume_token(LCOSTRING);
    t = new ASTCoLstringT();
      break;
    case SEND:
      jj_consume_token(SEND);
      l = Type();
      jj_consume_token(SEMIC);
      r = SType();
                                        t = new ASTSendT(l,r);
      break;
    case RECV:
      jj_consume_token(RECV);
      l = Type();
      jj_consume_token(SEMIC);
      r = SType();
                                        t = new ASTRecvT(l,r);
      break;
    case SENDT:
      jj_consume_token(SENDT);
      s = jj_consume_token(Id);
      jj_consume_token(SEMIC);
      r = SType();
                                       t = new ASTSendTT(s.image,r);
      break;
    case RECVT:
      jj_consume_token(RECVT);
      s = jj_consume_token(Id);
      jj_consume_token(SEMIC);
      r = SType();
                                       t = new ASTRecvTT(s.image,r);
      break;
    case CHOICE:
      jj_consume_token(CHOICE);
      jj_consume_token(OF);
      jj_consume_token(LBRA);
      ASTCaseT tc = new ASTCaseT();
      label_6:
      while (true) {
        TypeCase(tc);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VBAR:
          ;
          break;
        default:
          jj_la1[12] = jj_gen;
          break label_6;
        }
      }
      jj_consume_token(RBRA);
                               t = tc;
      break;
    case OFFER:
      jj_consume_token(OFFER);
      jj_consume_token(OF);
      jj_consume_token(LBRA);
      ASTOfferT to = new ASTOfferT();
      label_7:
      while (true) {
        TypeOffer(to);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VBAR:
          ;
          break;
        default:
          jj_la1[13] = jj_gen;
          break label_7;
        }
      }
      jj_consume_token(RBRA);
                                t = to;
      break;
    case CLOSE:
      jj_consume_token(CLOSE);
              t =CLOSETYPE;
      break;
    case CCLOSE:
      jj_consume_token(CCLOSE);
               t = WAITTYPE;
      break;
    case USAGE:
      jj_consume_token(USAGE);
      l = SType();
                         t = new ASTUsageT(l,false);
      break;
    case LUSAGE:
      jj_consume_token(LUSAGE);
      l = SType();
                          t = new ASTUsageT(l,true);
      break;
    case USAGEL:
      jj_consume_token(USAGEL);
      l = SType();
                          t = new ASTUsageLT(l,false);
      break;
    case LUSAGEL:
      jj_consume_token(LUSAGEL);
      l = SType();
                           t = new ASTUsageLT(l,true);
      break;
    case STATE:
      jj_consume_token(STATE);
      l = SType();
                         t = new ASTCellT(l,false);
      break;
    case LSTATE:
      jj_consume_token(LSTATE);
      l = SType();
                          t = new ASTCellT(l,true);
      break;
    case STATEL:
      jj_consume_token(STATEL);
      l = SType();
                          t = new ASTCellLT(l,false);
      break;
    case LSTATEL:
      jj_consume_token(LSTATEL);
      l = SType();
                           t = new ASTCellLT(l,true);
      break;
    case AFFINE:
      jj_consume_token(AFFINE);
      l = SType();
                         t = new ASTAffineT(l);
      break;
    case COAFFINE:
      jj_consume_token(COAFFINE);
      l = SType();
                           t = new ASTCoAffineT(l);
      break;
    case NOT:
      jj_consume_token(NOT);
      l = SType();
                      t = new ASTNotT(l);
      break;
    case BANG:
      jj_consume_token(BANG);
      l = SType();
                       t = new ASTBangT(l);
      break;
    case WHY:
      jj_consume_token(WHY);
      l = SType();
                      t = new ASTWhyT(l);
      break;
    case LBRA:
      jj_consume_token(LBRA);
      t = Type();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public void StructElem(ASTStructT lt) throws ParseException, Exception {
 Token s; ASTType t;
    s = jj_consume_token(lab);
    jj_consume_token(COL);
    t = Type();
    jj_consume_token(COMMA);
   lt.addCase(s.image,t);
  }

  final public void CoStructElem(ASTCoStructT lt) throws ParseException, Exception {
 Token s; ASTType t;
    s = jj_consume_token(lab);
    jj_consume_token(COL);
    t = Type();
    jj_consume_token(COMMA);
   lt.addCase(s.image,t);
  }

  final public void MutElem(ASTMutT lt) throws ParseException, Exception {
 Token s; ASTType t;
    s = jj_consume_token(lab);
    jj_consume_token(COL);
    t = Type();
    jj_consume_token(COMMA);
   lt.addCase(s.image,t);
  }

  final public void CoMutElem(ASTCoMutT lt) throws ParseException, Exception {
 Token s; ASTType t;
    s = jj_consume_token(lab);
    jj_consume_token(COL);
    t = Type();
    jj_consume_token(COMMA);
   lt.addCase(s.image,t);
  }

  final public void TypeCase(ASTCaseT lt) throws ParseException, Exception {
 Token s; ASTType t;
    jj_consume_token(VBAR);
    s = jj_consume_token(lab);
    jj_consume_token(COL);
    t = Type();
   lt.addCase(s.image,t);
  }

  final public void TypeOffer(ASTOfferT lt) throws ParseException, Exception {
 Token s; ASTType t;
    jj_consume_token(VBAR);
    s = jj_consume_token(lab);
    jj_consume_token(COL);
    t = Type();
   lt.addCase(s.image,t);
  }

  final public ASTProcDef Proc1D(boolean rec) throws ParseException, Exception {
 ASTNode p1; Token c1;
ASTProcDef p = new ASTProcDef();
    c1 = jj_consume_token(Id);
       p.setId(c1.image);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      jj_consume_token(LT);
      TParamList(p);
      jj_consume_token(GT);
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    jj_consume_token(LPAR);
    ParamList(p);
    jj_consume_token(RPAR);
    jj_consume_token(LBRA);
    p1 = Proc();
           p.setProc(p1);
           p1.setanc(p);
           p.setRec(rec);
    jj_consume_token(RBRA);
      {if (true) return p;}
    throw new Error("Missing return statement in function");
  }

  final public ASTNode ProcD() throws ParseException, Exception {
 ASTNode p1; Token c1;
boolean rec = false;
boolean unsafe_rec = false;
List<ASTProcDef> ld = new ArrayList<ASTProcDef>();
ASTProcDef p ;
    jj_consume_token(PROC);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REC:
    case UNSAFE_REC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REC:
        jj_consume_token(REC);
                 rec = true;
        break;
      case UNSAFE_REC:
        jj_consume_token(UNSAFE_REC);
                                                unsafe_rec = true;
        break;
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    p = Proc1D(rec);
                           ld.add(p);  p.setUnsafe_Rec(unsafe_rec);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[18] = jj_gen;
        break label_8;
      }
      jj_consume_token(AND);
      p = Proc1D(rec);
                              ld.add(p);
    }
      {if (true) return new ASTPList(ld, rec, unsafe_rec );}
    throw new Error("Missing return statement in function");
  }

  final public void ParamList(ASTProcDef p) throws ParseException, Exception {
 ASTType t; Token i;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case Id:
      i = jj_consume_token(Id);
      jj_consume_token(COL);
      t = Type();
                               p.addDPar(i.image,t);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[19] = jj_gen;
          break label_9;
        }
        jj_consume_token(COMMA);
        i = jj_consume_token(Id);
        jj_consume_token(COL);
        t = Type();
                                       p.addDPar(i.image,t);
      }
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMIC:
      jj_consume_token(SEMIC);
      i = jj_consume_token(Id);
      jj_consume_token(COL);
      t = Type();
                              p.addGPar(i.image,t);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[21] = jj_gen;
          break label_10;
        }
        jj_consume_token(COMMA);
        i = jj_consume_token(Id);
        jj_consume_token(COL);
        t = Type();
                                      p.addGPar(i.image,t);
      }
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
  }

  final public void TParamList(ASTProcDef p) throws ParseException, Exception {
 ASTType t; Token i;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case Id:
      i = jj_consume_token(Id);
                p.addTPar(i.image);
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[23] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
        i = jj_consume_token(Id);
                      p.addTPar(i.image);
      }
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
  }

  final public void ArgList(ASTId t) throws ParseException, Exception {
 ASTExpr pe;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
    case FALSE:
    case Id:
    case Num:
    case MINUS:
    case BANG:
    case LPAR:
    case STRING:
      pe = Expr();
                 t.addExpr(pe);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[25] = jj_gen;
          break label_12;
        }
        jj_consume_token(COMMA);
        pe = Expr();
                                                      t.addExpr(pe);
      }
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMIC:
      jj_consume_token(SEMIC);
      pe = Expr();
                            t.addGExpr(pe);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[27] = jj_gen;
          break label_13;
        }
        jj_consume_token(COMMA);
        pe = Expr();
                                                                  t.addGExpr(pe);
      }
      break;
    default:
      jj_la1[28] = jj_gen;
      ;
    }
  }

  final public void ArgTList(ASTId t) throws ParseException, Exception {
 ASTType ty;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LINT:
    case LCOINT:
    case LBOOL:
    case LCOBOOL:
    case LSTRING:
    case LCOSTRING:
    case SEND:
    case RECV:
    case SENDT:
    case RECVT:
    case CHOICE:
    case OFFER:
    case STATE:
    case LSTATE:
    case STATEL:
    case LSTATEL:
    case USAGE:
    case LUSAGE:
    case USAGEL:
    case LUSAGEL:
    case AFFINE:
    case COAFFINE:
    case CLOSE:
    case CCLOSE:
    case Id:
    case NOT:
    case BANG:
    case WHY:
    case LBRA:
      ty = Type();
                 t.addTpar(ty);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[29] = jj_gen;
          break label_14;
        }
        jj_consume_token(COMMA);
        ty = Type();
                                                      t.addTpar(ty);
      }
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
  }

  final public ASTExpr Expr() throws ParseException, Exception {
ASTExpr p1,p2,p;
ASTType t;
Token c1,c2;
    p1 = CExpr();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OR:
    case AND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        c1 = jj_consume_token(AND);
        p2 = CExpr();
                                p = new ASTAnd(p1,p2); p.lineno = c1.beginLine; p1.setanc(p); p2.setanc(p); p1 = p;
        break;
      case OR:
        c1 = jj_consume_token(OR);
        p2 = CExpr();
                               p = new ASTOr(p1,p2); p.lineno = c1.beginLine; p1.setanc(p); p2.setanc(p); p1 = p;
        break;
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
          {if (true) return p1;}
    throw new Error("Missing return statement in function");
  }

  final public ASTExpr CExpr() throws ParseException, Exception {
ASTExpr p1,p2,p;
ASTType t;
Token c1,c2;
    p1 = AExpr();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
    case GT:
    case EQ:
    case NEQ:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        c1 = jj_consume_token(EQ);
        p2 = AExpr();
                               p = new ASTEq(p1,p2); p.lineno = c1.beginLine; p1.setanc(p); p2.setanc(p); p1 = p;
        break;
      case NEQ:
        c1 = jj_consume_token(NEQ);
        p2 = AExpr();
                                p = new ASTNEq(p1,p2); p.lineno = c1.beginLine; p1.setanc(p); p2.setanc(p); p1 = p;
        break;
      case LT:
        c1 = jj_consume_token(LT);
        p2 = AExpr();
                               p = new ASTLt(p1,p2); p.lineno = c1.beginLine; p1.setanc(p); p2.setanc(p); p1 = p;
        break;
      case GT:
        c1 = jj_consume_token(GT);
        p2 = AExpr();
                               p = new ASTGt(p1,p2); p.lineno = c1.beginLine; p1.setanc(p); p2.setanc(p); p1 = p;
        break;
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[34] = jj_gen;
      ;
    }
          {if (true) return p1;}
    throw new Error("Missing return statement in function");
  }

  final public ASTExpr AExpr() throws ParseException, Exception {
ASTExpr p1,p2,p;
ASTType t;
Token c1,c2;
    p1 = Term();
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[35] = jj_gen;
        break label_15;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        c1 = jj_consume_token(PLUS);
        p2 = Term();
                                p = new ASTAdd(p1,p2); p.lineno = c1.beginLine; p1.setanc(p); p2.setanc(p); p1 = p;
        break;
      case MINUS:
        c1 = jj_consume_token(MINUS);
        p2 = Term();
                                 p=new ASTSub(p1,p2); p.lineno = c1.beginLine; p1.setanc(p); p2.setanc(p); p1 = p;
        break;
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
          {if (true) return p1;}
    throw new Error("Missing return statement in function");
  }

  final public ASTExpr Term() throws ParseException, Exception {
ASTExpr p1,p2,p;
ASTType t;
Token c1,c2;
    p1 = Fact();
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MOD:
      case TIMES:
      case DIV:
        ;
        break;
      default:
        jj_la1[37] = jj_gen;
        break label_16;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TIMES:
        c1 = jj_consume_token(TIMES);
        p2 = Fact();
                                 p = new ASTMul(p1,p2); p.lineno = c1.beginLine; p1.setanc(p); p2.setanc(p); p1 = p;
        break;
      case DIV:
        c1 = jj_consume_token(DIV);
        p2 = Fact();
                               p=new ASTDiv(p1,p2); p.lineno = c1.beginLine; p1.setanc(p); p2.setanc(p); p1 = p;
        break;
      case MOD:
        c1 = jj_consume_token(MOD);
        p2 = Fact();
                               p=new ASTMod(p1,p2); p.lineno = c1.beginLine; p1.setanc(p); p2.setanc(p); p1 = p;
        break;
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
          {if (true) return p1;}
    throw new Error("Missing return statement in function");
  }

  final public ASTExpr Fact() throws ParseException, Exception {
ASTExpr p1,p2,p;
ASTType t;
Token c1,c2;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case Num:
      c1 = jj_consume_token(Num);
                   p = new ASTInt(Integer.parseInt(c1.image)); p.lineno = c1.beginLine;
      break;
    case TRUE:
      c1 = jj_consume_token(TRUE);
                    p = new ASTBool(true); p.lineno = c1.beginLine;
      break;
    case FALSE:
      c1 = jj_consume_token(FALSE);
                     p = new ASTBool(false); p.lineno = c1.beginLine;
      break;
    case STRING:
      c1 = jj_consume_token(STRING);
                      p = new ASTString(c1.image.substring(1,c1.image.length()-1)); p.lineno = c1.beginLine;
      break;
    case Id:
      c1 = jj_consume_token(Id);
                  p = new ASTVId(c1.image); p.lineno = c1.beginLine;
      break;
    case LPAR:
      jj_consume_token(LPAR);
      p = Expr();
      jj_consume_token(RPAR);
      break;
    case MINUS:
      c1 = jj_consume_token(MINUS);
      p = Fact();
                                  p1 = new ASTSub(new ASTInt(0),p); p1.lineno = c1.beginLine; p.setanc(p1); p = p1;
      break;
    case BANG:
      c1 = jj_consume_token(BANG);
      p = Fact();
                                 p1 = new ASTNot(p); p1.lineno = c1.beginLine; p.setanc(p1); p = p1;
      break;
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return p;}
    throw new Error("Missing return statement in function");
  }

  final public ASTNode CCut(boolean con) throws ParseException, Exception {
ASTNode p1,p2,p;
ASTExpr pe;
ASTType t;
Token c1,c2;
String str;
    p1 = Proc();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VBAR:
      jj_consume_token(VBAR);
      c1 = jj_consume_token(Id);
      jj_consume_token(COL);
      t = Type();
      jj_consume_token(VBAR);
      p2 = CCut(con);
   ASTCut pc = new ASTCut(c1.image,t,p1,p2);
   pc.con = con;
   p = pc;
   p1.setanc(p);
   p2.setanc(p);
   p1 = p;
      break;
    default:
      jj_la1[40] = jj_gen;
      ;
    }
   {if (true) return p1;}
    throw new Error("Missing return statement in function");
  }

  final public ASTNode Proc() throws ParseException, Exception {
ASTNode p1,p2,p;
ASTExpr pe;
ASTType t = null;
Token c1,c2,c3,c4,c5;
String str;
boolean b;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLLTYPE:
      jj_consume_token(CLLTYPE);
      c2 = jj_consume_token(Id);
      jj_consume_token(SEMIC);
      p2 = Proc();
      p = new ASTCLLType(c2.image,p2);
      p2.setanc(p);
      break;
    case PRINT:
      jj_consume_token(PRINT);
      pe = Expr();
      jj_consume_token(SEMIC);
      p2 = Proc();
      p = new ASTPrintLn(pe,p2,false);
      p2.setanc(p);
      pe.setanc(p);
      break;
    case SLEEP:
      c2 = jj_consume_token(SLEEP);
      c1 = jj_consume_token(Num);
      jj_consume_token(SEMIC);
      p = Proc();
      p1 = new ASTSleep(Integer.parseInt(c1.image),p);
      p.setanc(p1);
      p = p1;
      p1.lineno = c2.beginLine;
      break;
    case PRINTLN:
      c1 = jj_consume_token(PRINTLN);
      jj_consume_token(LPAR);
     pe = null;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
      case FALSE:
      case Id:
      case Num:
      case MINUS:
      case BANG:
      case LPAR:
      case STRING:
        pe = Expr();
        break;
      default:
        jj_la1[41] = jj_gen;
        ;
      }
      jj_consume_token(RPAR);
      jj_consume_token(SEMIC);
      p2 = Proc();
      if (pe==null) pe = new ASTString("");
      p = new ASTPrintLn(pe,p2,true);
      p.lineno = c1.beginLine;
      pe.setanc(p);
      p2.setanc(p);
      break;
    case IF:
      c1 = jj_consume_token(IF);
      pe = Expr();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case THEN:
        jj_consume_token(THEN);
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      jj_consume_token(LBRA);
      p1 = Proc();
      jj_consume_token(RBRA);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        jj_consume_token(ELSE);
        break;
      default:
        jj_la1[43] = jj_gen;
        ;
      }
      jj_consume_token(LBRA);
      p2 = Proc();
      jj_consume_token(RBRA);
      p = new ASTIf(pe,p1,p2);
      pe.setanc(p);
      p1.setanc(p);
      p2.setanc(p);
      p.lineno = c1.beginLine;
      break;
    case LET:
      c1 = jj_consume_token(LET);
      c2 = jj_consume_token(Id);
      pe = Expr();
    p = new ASTCoExpr(c2.image, pe);
    pe.setanc(p);
    p.lineno = c1.beginLine;
      break;
    case LETB:
      c1 = jj_consume_token(LETB);
      c2 = jj_consume_token(Id);
      pe = Expr();
    p = new ASTPromoCoExpr(c2.image, pe);
    pe.setanc(p);
    p.lineno = c1.beginLine;
      break;
    case LPAR:
      c1 = jj_consume_token(LPAR);
      jj_consume_token(RPAR);
      p = new ASTEmpty(); p.lineno = c1.beginLine;
      break;
    case Id:
      /*
          <LBRA> p=Proc() <RBRA>
          |
          */
      
          /* new forms */
      
          c1 = jj_consume_token(Id);
              p = new ASTId(c1.image);
      p.lineno = c1.beginLine;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RIGHTA:
        jj_consume_token(RIGHTA);
        c2 = jj_consume_token(Id);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COL:
          jj_consume_token(COL);
          t = Type();
          break;
        default:
          jj_la1[44] = jj_gen;
          ;
        }
        jj_consume_token(SEMIC);
        p1 = Proc();
          p = new ASTRecv(c1.image,c2.image,t,p1); p.lineno = c1.beginLine; p1.setanc(p);
        break;
      case LEFTA:
      case LPAR:
      case LT:
      case COL:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LEFTA:
        case COL:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COL:
            jj_consume_token(COL);
            t = Type();
            break;
          default:
            jj_la1[45] = jj_gen;
            ;
          }
          jj_consume_token(LEFTA);
          if (jj_2_1(2)) {
            jj_consume_token(LBRA);
            c2 = jj_consume_token(Id);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COL:
              jj_consume_token(COL);
              t = Type();
              break;
            default:
              jj_la1[46] = jj_gen;
              ;
            }
            jj_consume_token(DOT);
            p1 = Proc();
            jj_consume_token(RBRA);
            jj_consume_token(SEMIC);
            p2 = Proc();
        p = new ASTSend(c1.image,c2.image,t,p1,p2);
        p.lineno = c1.beginLine;
        p1.setanc(p); p2.setanc(p);
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case TRUE:
            case FALSE:
            case Id:
            case Num:
            case MINUS:
            case BANG:
            case LPAR:
            case STRING:
              pe = Expr();
              jj_consume_token(SEMIC);
              p2 = Proc();
        p = new ASTSend(c1.image,ASTType.gensym(),null,pe,p2);
        p.lineno = c1.beginLine;
        pe.setanc(p); p2.setanc(p);
              break;
            default:
              jj_la1[47] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
        case LPAR:
        case LT:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LT:
            jj_consume_token(LT);
            ArgTList((ASTId)p);
            jj_consume_token(GT);
            break;
          default:
            jj_la1[48] = jj_gen;
            ;
          }
          jj_consume_token(LPAR);
          ArgList((ASTId)p);
          jj_consume_token(RPAR);
    p2 = null;
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SEMIC:
            jj_consume_token(SEMIC);
            p2 = Proc();
            break;
          default:
            jj_la1[49] = jj_gen;
            ;
          }
      p1 = p;
      if (p2!=null) {  p = new ASTMix(false,p1,p2); p1.setanc(p); p2.setanc(p); } else p = p1;
      p.lineno = c1.beginLine;
          break;
        default:
          jj_la1[50] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[51] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case CUT:
      c1 = jj_consume_token(CUT);
      jj_consume_token(LBRA);
      p1 = CCut(false);
      jj_consume_token(RBRA);
      p = p1; p.lineno = c1.beginLine;
      break;
    case CCUT:
      c1 = jj_consume_token(CCUT);
      jj_consume_token(LBRA);
      p1 = CCut(true);
      jj_consume_token(RBRA);
      p = p1; p.lineno = c1.beginLine;
      break;
    case LETC:
      c2 = jj_consume_token(LETC);
      c1 = jj_consume_token(Id);
                           t = null;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COL:
        jj_consume_token(COL);
        t = Type();
        break;
      default:
        jj_la1[52] = jj_gen;
        ;
      }
      jj_consume_token(LBRA);
      p1 = Proc();
      jj_consume_token(RBRA);
      jj_consume_token(SEMIC);
      p2 = Proc();
              p = new ASTCut(c1.image,t,p2,p1);
              p.lineno = c2.beginLine;
              p1.setanc(p);
              p2.setanc(p);
      break;
    case MIX:
      c1 = jj_consume_token(MIX);
      jj_consume_token(LBRA);
      p1 = Proc();
      label_17:
      while (true) {
        jj_consume_token(VBAR);
        jj_consume_token(VBAR);
        p2 = Proc();
            p = new ASTMix(false,p1,p2); p.lineno = c1.beginLine; p1.setanc(p); p2.setanc(p); p1=p;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VBAR:
          ;
          break;
        default:
          jj_la1[53] = jj_gen;
          break label_17;
        }
      }
      jj_consume_token(RBRA);
      p = p1;
      break;
    case CMIX:
      c1 = jj_consume_token(CMIX);
      jj_consume_token(LBRA);
      p1 = Proc();
      label_18:
      while (true) {
        jj_consume_token(VBAR);
        jj_consume_token(VBAR);
        p2 = Proc();
            p = new ASTMix(true,p1,p2); p.lineno = c1.beginLine; p1.setanc(p); p2.setanc(p); p1=p;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VBAR:
          ;
          break;
        default:
          jj_la1[54] = jj_gen;
          break label_18;
        }
      }
      jj_consume_token(RBRA);
      p = p1;
      break;
    case SHARE:
    case SSHARE:
          boolean cs = true;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SHARE:
        c2 = jj_consume_token(SHARE);
        break;
      case SSHARE:
        c2 = jj_consume_token(SSHARE);
                                                                 cs = false;
        break;
      default:
        jj_la1[55] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      c1 = jj_consume_token(Id);
      jj_consume_token(LBRA);
      p1 = Proc();
      label_19:
      while (true) {
        jj_consume_token(VBAR);
        jj_consume_token(VBAR);
        p2 = Proc();
              p =new ASTShare(c1.image,p1,p2,cs);  p.lineno =
             c2.beginLine; p1.setanc(p); p2.setanc(p); p1=p;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VBAR:
          ;
          break;
        default:
          jj_la1[56] = jj_gen;
          break label_19;
        }
      }
      jj_consume_token(RBRA);
               p = p1;
      break;
    case SHAREL:
      c2 = jj_consume_token(SHAREL);
      c1 = jj_consume_token(Id);
      jj_consume_token(LBRA);
      p1 = Proc();
      jj_consume_token(VBAR);
      jj_consume_token(VBAR);
      p2 = Proc();
      jj_consume_token(RBRA);
      p = new ASTShareL(c1.image,p1,p2);p.lineno = c2.beginLine; p1.setanc(p); p2.setanc(p);
      break;
    case SHARER:
      c2 = jj_consume_token(SHARER);
      c1 = jj_consume_token(Id);
      jj_consume_token(LBRA);
      p1 = Proc();
      jj_consume_token(VBAR);
      jj_consume_token(VBAR);
      p2 = Proc();
      jj_consume_token(RBRA);
      p = new ASTShareR(c1.image,p1,p2); p.lineno = c2.beginLine; p1.setanc(p); p2.setanc(p);
      break;
    case SEND:
      c3 = jj_consume_token(SEND);
      c1 = jj_consume_token(Id);
      jj_consume_token(LPAR);
      if (jj_2_2(2)) {
        c2 = jj_consume_token(Id);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COL:
          jj_consume_token(COL);
          t = Type();
          break;
        default:
          jj_la1[57] = jj_gen;
          ;
        }
        jj_consume_token(DOT);
        p1 = Proc();
        jj_consume_token(RPAR);
        jj_consume_token(SEMIC);
        p2 = Proc();
        p = new ASTSend(c1.image,c2.image,t,p1,p2);
        p.lineno = c3.beginLine;
        p1.setanc(p); p2.setanc(p);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TRUE:
        case FALSE:
        case Id:
        case Num:
        case MINUS:
        case BANG:
        case LPAR:
        case STRING:
          pe = Expr();
          jj_consume_token(RPAR);
          jj_consume_token(SEMIC);
          p2 = Proc();
       p = new ASTSend(c1.image,ASTType.gensym(),null,pe,p2);
       p.lineno = c3.beginLine;
       pe.setanc(p); p2.setanc(p);
          break;
        default:
          jj_la1[58] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    case RECV:
      c3 = jj_consume_token(RECV);
      c1 = jj_consume_token(Id);
      jj_consume_token(LPAR);
      c2 = jj_consume_token(Id);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COL:
        jj_consume_token(COL);
        t = Type();
        break;
      default:
        jj_la1[59] = jj_gen;
        ;
      }
      jj_consume_token(RPAR);
      jj_consume_token(SEMIC);
      p1 = Proc();
      p = new ASTRecv(c1.image,c2.image,t,p1); p.lineno = c3.beginLine; p1.setanc(p);
      break;
    case SENDT:
      c3 = jj_consume_token(SENDT);
      c1 = jj_consume_token(Id);
      jj_consume_token(LPAR);
      t = Type();
      jj_consume_token(RPAR);
      jj_consume_token(SEMIC);
      p2 = Proc();
      p = new ASTSendTy(c1.image,t,p2) ; p2.setanc(p); p.lineno = c3.beginLine;
      break;
    case RECVT:
      c3 = jj_consume_token(RECVT);
      c1 = jj_consume_token(Id);
      jj_consume_token(LPAR);
      c2 = jj_consume_token(Id);
      jj_consume_token(RPAR);
      jj_consume_token(SEMIC);
      p1 = Proc();
      p = new ASTRecvTy(c1.image,c2.image,p1); p.lineno = c3.beginLine; p1.setanc(p);
      break;
    case CASE:
      c3 = jj_consume_token(CASE);
      c1 = jj_consume_token(Id);
      jj_consume_token(OF);
      jj_consume_token(LBRA);
      ASTCase tc = new ASTCase(c1.image);
      label_20:
      while (true) {
        ProcCase(tc);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VBAR:
          ;
          break;
        default:
          jj_la1[60] = jj_gen;
          break label_20;
        }
      }
      jj_consume_token(RBRA);
                                p = tc; p.lineno = c3.beginLine;
      break;
    case lab:
      c1 = jj_consume_token(lab);
      c2 = jj_consume_token(Id);
      jj_consume_token(SEMIC);
      p1 = Proc();
      p = new ASTSelect(c2.image, c1.image, p1); p.lineno = c1.beginLine;
      p1.setanc(p);
      break;
    case CLOSE:
      c2 = jj_consume_token(CLOSE);
                    p2 = null;
      c1 = jj_consume_token(Id);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMIC:
        jj_consume_token(SEMIC);
        p2 = Proc();
        break;
      default:
        jj_la1[61] = jj_gen;
        ;
      }
      p1 = new ASTClose(c1.image);
      if (p2!=null) {  p = new ASTMix(false,p1,p2); p1.setanc(p); p2.setanc(p); } else p = p1;
      p.lineno = c2.beginLine;
      break;
    case CCLOSE:
      c2 = jj_consume_token(CCLOSE);
      c1 = jj_consume_token(Id);
      jj_consume_token(SEMIC);
      p1 = Proc();
                                                p = new ASTCoClose(c1.image,p1); p.lineno = c2.beginLine;  p1.setanc(p);
      break;
    case UNFOLD:
      c2 = jj_consume_token(UNFOLD);
      c1 = jj_consume_token(Id);
      jj_consume_token(SEMIC);
      p1 = Proc();
                                                p = new ASTUnfold(c1.image,p1);p.lineno = c2.beginLine; p1.setanc(p);
      break;
    case CELL:
      c3 = jj_consume_token(CELL);
      c1 = jj_consume_token(Id);
      jj_consume_token(LPAR);
      if (jj_2_3(2)) {
        c2 = jj_consume_token(Id);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COL:
          jj_consume_token(COL);
          t = Type();
          break;
        default:
          jj_la1[62] = jj_gen;
          ;
        }
        jj_consume_token(DOT);
        p1 = Proc();
        jj_consume_token(RPAR);
      p = new ASTCell(c1.image,c2.image,t,p1); p.lineno = c3.beginLine;  p1.setanc(p);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TRUE:
        case FALSE:
        case Id:
        case Num:
        case MINUS:
        case BANG:
        case LPAR:
        case STRING:
          pe = Expr();
          jj_consume_token(RPAR);
    p = new ASTCell(c1.image,ASTType.gensym(),null,pe); p.lineno = c3.beginLine; pe.setanc(p);
          break;
        default:
          jj_la1[63] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    case EMPTY:
      c3 = jj_consume_token(EMPTY);
      c1 = jj_consume_token(Id);
      p = new ASTEmptyCell(c1.image); p.lineno = c3.beginLine;
      break;
    case DISCARD:
      c2 = jj_consume_token(DISCARD);
                     p2 = null;
      c1 = jj_consume_token(Id);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMIC:
        jj_consume_token(SEMIC);
        p2 = Proc();
        break;
      default:
        jj_la1[64] = jj_gen;
        ;
      }
      p1 = new ASTDiscard(c1.image);
      if (p2!=null) {  p = new ASTMix(false,p1,p2); p1.setanc(p); p2.setanc(p); } else p = p1;
      p.lineno = c2.beginLine;
      break;
    case USE:
      c3 = jj_consume_token(USE);
      c1 = jj_consume_token(Id);
      jj_consume_token(SEMIC);
      p1 = Proc();
        p = new ASTUse(c1.image, p1);
        p.lineno = c3.beginLine;
        p1.setanc(p);
        // p = p1;

      break;
    case AFFINE:
      c3 = jj_consume_token(AFFINE);
      c1 = jj_consume_token(Id);
      jj_consume_token(SEMIC);
      p1 = Proc();
      p = new ASTAffine(c1.image, p1); p.lineno = c3.beginLine;  p1.setanc(p);
      break;
    case RELEASE:
      c2 = jj_consume_token(RELEASE);
                      p2 = null;
      c1 = jj_consume_token(Id);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMIC:
        jj_consume_token(SEMIC);
        p2 = Proc();
        break;
      default:
        jj_la1[65] = jj_gen;
        ;
      }
      p1 = new ASTRelease(c1.image);
      if (p2!=null) {  p = new ASTMix(false,p1,p2); p1.setanc(p); p2.setanc(p); } else p = p1;
      p.lineno = c2.beginLine;
      break;
    case PUT:
      c3 = jj_consume_token(PUT);
      c1 = jj_consume_token(Id);
      jj_consume_token(LPAR);
      if (jj_2_4(2)) {
        c2 = jj_consume_token(Id);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COL:
          jj_consume_token(COL);
          t = Type();
          break;
        default:
          jj_la1[66] = jj_gen;
          ;
        }
        jj_consume_token(DOT);
        p1 = Proc();
        jj_consume_token(RPAR);
        jj_consume_token(SEMIC);
        p2 = Proc();
      p = new ASTPut(c1.image,c2.image,t,p1,p2);
      p.lineno = c3.beginLine;
      p1.setanc(p);
      p2.setanc(p);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TRUE:
        case FALSE:
        case Id:
        case Num:
        case MINUS:
        case BANG:
        case LPAR:
        case STRING:
          pe = Expr();
          jj_consume_token(RPAR);
          jj_consume_token(SEMIC);
          p2 = Proc();
       p = new ASTPut(c1.image,ASTType.gensym(),null,pe,p2);
       p.lineno = c3.beginLine;  pe.setanc(p);  p2.setanc(p);
          break;
        default:
          jj_la1[67] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    case TAKE:
      c3 = jj_consume_token(TAKE);
      c1 = jj_consume_token(Id);
      jj_consume_token(LPAR);
      c2 = jj_consume_token(Id);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COL:
        jj_consume_token(COL);
        t = Type();
        break;
      default:
        jj_la1[68] = jj_gen;
        ;
      }
      jj_consume_token(RPAR);
      jj_consume_token(SEMIC);
      p1 = Proc();
           p = new ASTTake(c1.image,c2.image,t,p1);
            p.lineno = c3.beginLine; p1.setanc(p);
      break;
    case LOCK:
      c3 = jj_consume_token(LOCK);
      c1 = jj_consume_token(Id);
      jj_consume_token(SEMIC);
      p1 = Proc();
      p = new ASTLock(c1.image,p1); p.lineno = c3.beginLine;  p1.setanc(p);
      break;
    case UNLK:
      c3 = jj_consume_token(UNLK);
      c1 = jj_consume_token(Id);
      jj_consume_token(SEMIC);
      p1 = Proc();
      p = new ASTUnlock(c1.image,p1); p.lineno = c3.beginLine; p1.setanc(p);
      break;
    case WRT:
      c3 = jj_consume_token(WRT);
      c1 = jj_consume_token(Id);
      jj_consume_token(LPAR);
      c2 = jj_consume_token(Id);
      jj_consume_token(COL);
      t = Type();
      jj_consume_token(DOT);
      p1 = Proc();
      jj_consume_token(RPAR);
      jj_consume_token(SEMIC);
      p2 = Proc();
      p = new ASTWrt(c1.image,c2.image,t,p1,p2); p.lineno = c3.beginLine; p1.setanc(p);  p2.setanc(p);
      break;
    case RD:
      c3 = jj_consume_token(RD);
      c1 = jj_consume_token(Id);
      jj_consume_token(LPAR);
      c2 = jj_consume_token(Id);
      jj_consume_token(COL);
      t = Type();
      jj_consume_token(RPAR);
      jj_consume_token(SEMIC);
      p1 = Proc();
      p = new ASTRead(c1.image,c2.image,t,p1); p.lineno = c3.beginLine;  p1.setanc(p);
      break;
    case FWD:
      c3 = jj_consume_token(FWD);
      c1 = jj_consume_token(Id);
      c2 = jj_consume_token(Id);
                                 p = new ASTFwd(c1.image, c2.image); p.lineno = c3.beginLine;
      break;
    case FWDB:
      c3 = jj_consume_token(FWDB);
      c1 = jj_consume_token(Id);
      c2 = jj_consume_token(Id);
                                  p = new ASTFwdB(c1.image, c2.image); p.lineno = c3.beginLine;
      break;
    case BANG:
      c3 = jj_consume_token(BANG);
      c1 = jj_consume_token(Id);
      jj_consume_token(LPAR);
      c2 = jj_consume_token(Id);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COL:
        jj_consume_token(COL);
        t = Type();
        break;
      default:
        jj_la1[69] = jj_gen;
        ;
      }
      jj_consume_token(RPAR);
      jj_consume_token(SEMIC);
      p1 = Proc();
      p = new ASTBang(c1.image,c2.image,t,p1); p.lineno = c3.beginLine;  p1.setanc(p);
      break;
    case CALL:
      c3 = jj_consume_token(CALL);
      c1 = jj_consume_token(Id);
      jj_consume_token(LPAR);
      c2 = jj_consume_token(Id);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COL:
        jj_consume_token(COL);
        t = Type();
        break;
      default:
        jj_la1[70] = jj_gen;
        ;
      }
      jj_consume_token(RPAR);
      jj_consume_token(SEMIC);
      p1 = Proc();
      p = new ASTCall(c1.image,c2.image,t,p1); p.lineno = c3.beginLine; p1.setanc(p);
      break;
    case WHY:
      c3 = jj_consume_token(WHY);
      c1 = jj_consume_token(Id);
      jj_consume_token(SEMIC);
      p1 = Proc();
          p = new ASTWhy(c1.image,p1); p.lineno = c3.beginLine;  p1.setanc(p) ;
            //p = p1;

      break;
    case FOR:
      jj_consume_token(FOR);
      c1 = jj_consume_token(Id);
      jj_consume_token(COL);
      t = Type();
      jj_consume_token(TO);
      c2 = jj_consume_token(Id);
      jj_consume_token(LPAR);
      c3 = jj_consume_token(Id);
      jj_consume_token(COMMA);
      c4 = jj_consume_token(Id);
      jj_consume_token(SEMIC);
      c5 = jj_consume_token(Id);
      jj_consume_token(RPAR);
      jj_consume_token(LBRA);
      p1 = Proc();
      jj_consume_token(RBRA);
          p = ASTNode.ForMacroFactory(c1.image,t,c2.image,c3.image,c4.image,c5.image, p1);
           p1.setanc(p);  // provisional

      break;
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return p;}
    throw new Error("Missing return statement in function");
  }

  final public void ProcCase(ASTCase lt) throws ParseException, Exception {
 Token s; ASTNode t;
    jj_consume_token(VBAR);
    s = jj_consume_token(lab);
    jj_consume_token(COL);
    t = Proc();
   lt.addCase(s.image,t);
   t.setanc(lt);
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_3R_23() {
    if (jj_scan_token(COL)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_scan_token(Id)) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_scan_token(Id)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_22()) jj_scanpos = xsp;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_scan_token(Id)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_21()) jj_scanpos = xsp;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_scan_token(COL)) return true;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_scan_token(COL)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(Id)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_23()) jj_scanpos = xsp;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public CLLSjTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[72];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0xfc021a01,0x0,0x14000,0x14000,0x0,0x0,0x0,0x3f00000,0x0,0x0,0x0,0x0,0x0,0x0,0x3f00000,0x0,0xc000,0xc000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9c021a00,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x63ff7f,0x0,0x0,0x0,0x0,0x0,0x0,0x7f8c001d,0x0,0x0,0x0,0x0,0x0,0x0,0x7f8c001d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f8c001d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ff7d,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x3ffbe8,0x0,0x0,0x0,0x800000,0x0,0x0,0x3018,0x0,0x0,0x0,0x0,0x0,0x0,0x3018,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18000000,0x0,0x0,0x0,0x3018,0xc00000,0xc00000,0x0,0x0,0x0,0x0,0x0,0x0,0x18000000,0x0,0x18000000,0x2000000,0x4000000,0x0,0x0,0x0,0x18000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000,0x0,0x0,0x18000000,0x0,0x0,0x0,0x0,0x18000000,0x0,0x0,0x0,0x18000000,0x0,0x0,0x0,0x37fbe8,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x2c00da,0x200000,0x0,0x0,0x0,0x80,0x0,0x8d0080,0x0,0x4004000,0x4004000,0x200000,0x200,0x200,0x8d0080,0x10000000,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x80,0x0,0x242180,0x0,0x0,0x0,0x8d0080,0x0,0x0,0x70000000,0x70000000,0x3000,0x3000,0xc020,0xc020,0x242180,0x200,0x242180,0x0,0x0,0x0,0x0,0x0,0x242180,0x10000000,0x0,0x10200400,0x10200c00,0x0,0x200,0x200,0x0,0x200,0x0,0x242180,0x0,0x200,0x0,0x0,0x242180,0x0,0x0,0x0,0x242180,0x0,0x0,0x0,0x2c00c0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x4,0x8,0x0,0x8,0x40,0x8,0x4,0x8,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x40,0x0,0x40,0x0,0x0,0x10,0x10,0x10,0x40,0x0,0x4,0x10,0x10,0x10,0x0,0x0,0x0,0x0,0x10,0x40,0x10,0x0,0x4,0x10,0x40,0x4,0x4,0x10,0x40,0x10,0x10,0x10,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[4];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public CLLSj(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public CLLSj(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new CLLSjTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public CLLSj(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new CLLSjTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public CLLSj(CLLSjTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CLLSjTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[135];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 72; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 135; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 4; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
