import java.util.*;
import java.util.logging.*;
import java.util.function.*;

public class ASTSleep extends ASTNode {

    int msecs;

    ASTNode rhs;

    ASTSleep(int time, ASTNode rhs){
        this.msecs = time; this.rhs = rhs;
    }

    public  void ASTInsertPipe(Function<ASTNode,ASTNode> f, ASTNode from) throws Exception
    {
	if (from==rhs) { ASTNode nnode = f.apply(from);
	    rhs.setanc(nnode);
	    rhs = nnode;
	    nnode.setanc(this);
	} else {
	    throw new Exception("ASTInsertPipe: call not expected");   
	}
    }

    public  void ASTInsertUse(String _ch,ASTType t, ASTNode here, Boolean disCont) throws Exception
    {
	anc.ASTInsertUse(_ch,t, this, disCont);
    }

    public void ASTInsertWhyNot(String ch, ASTType _t, ASTNode here) throws Exception
    {
        anc.ASTInsertWhyNot(ch, _t, this);
    }

    public void ASTInsertCall(String ch, String cho, ASTType t, ASTNode here) throws Exception{
        ASTNode pushCall = new ASTCall(ch, cho, t,here);
        pushCall.eg = eg;
        here.setanc(pushCall);
        pushCall.setanc(this);
        rhs = pushCall;
    }

    public ASTNode ASTweakeningOnLeaf(String _ch, ASTType typ, boolean exp) throws Exception
    {
	rhs = rhs.ASTweakeningOnLeaf(_ch,typ, exp);
	return this;
    }

    public void ASTupdCont(ASTNode newCont, ASTNode caller) throws Exception{
        rhs = newCont;
    }
  
    public void typecheck(Env<ASTType> ed, Env<ASTType> eg, Env<EnvEntry> ep) throws Exception {
        rhs.typecheck(ed,eg,ep);
    }

    public Set<String> fn(Set<String> s) {
        s = rhs.fn(s);
        return s;
    }

    public Set<String> fnLinear(Set<String> s) {
        s = rhs.fnLinear(s);
        return s;
    }
    
        public ASTNode subst(Env<ASTType> e) {
	    ASTSleep p = new ASTSleep(msecs,rhs.subst(e));
	    p.rhs.setanc(p);
	    return p;
	}

    public void subs(String x, String y){// implements x/y (substitutes y by x)
        rhs.subs(x,y);
    }

    public void runproc(Env<EnvEntry> ep, Env<LinSession> ed,
	Env<Server> eg, Logger logger) throws Exception {
	Thread.sleep(msecs);
        rhs.runproc(ep,ed,eg, logger);
    }

    public void samL(Env<SessionField> frame, Env<EnvEntry> ep,
		     SAMCont p_cont) throws Exception  {
	Thread.sleep(msecs);
	rhs.samL(frame,ep,p_cont);
    }
    
}
