/*
 * Decompiled with CFR 0.152.
 */
package z3;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import z3.AbstractTheoryProxy;
import z3.Pointer;
import z3.scala.Z3Context;

public final class Z3Wrapper {
    private static final String DS = File.separator;
    private static final String PS = File.pathSeparator;
    private static final String LIB_BIN = DS + "lib-bin" + DS;
    private static final String LIB_NAME = "scalaz3";
    private static final String LIBZ3_NAME = "libz3";
    public static Object gc_lock = new Object();
    private static final String versionString = "61f7962552d79e96a73fe47615a6b35d";
    private static final String isDebug = System.getProperty("scalaz3.debug.load");
    private static HashMap<Long, WeakReference<Z3Context>> ptrToCtx;
    private static HashMap<Long, AbstractTheoryProxy> tpmap;

    private static void debug(String string2) {
        if (isDebug != null) {
            System.out.println(string2);
        }
    }

    public static boolean withinJar() {
        URL uRL = Z3Wrapper.class.getResource("/lib-bin/");
        return uRL != null;
    }

    public static String wrapperVersionString() {
        return "ScalaZ3 4.0.a (in dev.)";
    }

    public static String z3VersionString() {
        IntPtr intPtr = new IntPtr();
        IntPtr intPtr2 = new IntPtr();
        IntPtr intPtr3 = new IntPtr();
        IntPtr intPtr4 = new IntPtr();
        Z3Wrapper.getVersion(intPtr, intPtr2, intPtr3, intPtr4);
        return "Z3 " + intPtr.value + "." + intPtr2.value + " (build " + intPtr3.value + ", rev. " + intPtr4.value + ")";
    }

    private static void loadFromJar() {
        String string2 = "SCALAZ3_61f7962552d79e96a73fe47615a6b35d";
        File file = new File(System.getProperty("java.io.tmpdir") + DS + string2 + LIB_BIN);
        String string3 = System.mapLibraryName(LIB_NAME);
        try {
            if (!file.isDirectory() || !file.canRead()) {
                file.mkdirs();
                Z3Wrapper.extractFromJar(file);
            }
            Z3Wrapper.addLibraryPath(file.getAbsolutePath());
            String string4 = System.getProperty("os.name");
            if (string4 != null && string4.indexOf("Win") >= 0) {
                Z3Wrapper.debug("Loading libz3");
                System.loadLibrary(LIBZ3_NAME);
            }
            Z3Wrapper.debug("Loading scalaz3");
            System.loadLibrary(LIB_NAME);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void addLibraryPath(String string2) throws Exception {
        System.setProperty("java.library.path", string2 + PS + System.getProperty("java.library.path"));
        Field field2 = ClassLoader.class.getDeclaredField("sys_paths");
        field2.setAccessible(true);
        field2.set(null, null);
    }

    private static void extractFromJar(File file) throws Exception {
        CodeSource codeSource = Z3Wrapper.class.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            ZipEntry zipEntry;
            URL uRL = codeSource.getLocation();
            ZipInputStream zipInputStream = new ZipInputStream(uRL.openStream());
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                String string2 = zipEntry.getName();
                if (!string2.startsWith("lib-bin/") || zipEntry.isDirectory()) continue;
                String string3 = new File(string2).getName();
                Z3Wrapper.debug("Extracting " + string2 + " from jar to " + string3 + "...");
                File file2 = new File(file.getAbsolutePath() + DS + string3);
                InputStream inputStream = Z3Wrapper.class.getResourceAsStream("/" + string2);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        }
    }

    public static long[] toPtrArray(Pointer[] pointerArray) {
        long[] lArray = new long[pointerArray.length];
        for (int i = 0; i < pointerArray.length; ++i) {
            lArray[i] = pointerArray[i].ptr;
        }
        return lArray;
    }

    public static void onZ3Error(long l, long l2) {
        Z3Context z3Context = (Z3Context)ptrToCtx.get(l).get();
        z3Context.onError(l2);
    }

    public static void registerContext(long l, Z3Context z3Context) {
        ptrToCtx.put(l, new WeakReference<Z3Context>(z3Context));
    }

    public static void unregisterContext(long l) {
        ptrToCtx.remove(l);
    }

    public static native long mkConfig();

    public static native void openLog(String var0);

    public static native void delConfig(long var0);

    public static native void setParamValue(long var0, String var2, String var3);

    public static native long mkContext(long var0);

    public static native long mkContextRC(long var0);

    public static native void incRef(long var0, long var2);

    public static native void decRef(long var0, long var2);

    public static native void interrupt(long var0);

    public static native void delContext(long var0);

    public static native void toggleWarningMessages(boolean var0);

    public static native void updateParamValue(long var0, String var2, String var3);

    public static native long mkIntSymbol(long var0, int var2);

    public static native long mkStringSymbol(long var0, String var2);

    public static native boolean isEqSort(long var0, long var2, long var4);

    public static native long mkUninterpretedSort(long var0, long var2);

    public static native long mkBoolSort(long var0);

    public static native long mkIntSort(long var0);

    public static native long mkRealSort(long var0);

    public static native long mkConstructor(long var0, long var2, long var4, int var6, long[] var7, long[] var8, int[] var9);

    public static native void queryConstructor(long var0, long var2, int var4, Pointer var5, Pointer var6, long[] var7);

    public static native long mkConstructorList(long var0, int var2, long[] var3);

    public static native void delConstructorList(long var0, long var2);

    public static native long[] mkDatatypes(long var0, int var2, long[] var3, long[] var4);

    public static native boolean isEqAST(long var0, long var2, long var4);

    public static native long mkApp(long var0, long var2, int var4, long[] var5);

    public static native boolean isEqFuncDecl(long var0, long var2, long var4);

    public static native long mkConst(long var0, long var2, long var4);

    public static native long mkFuncDecl(long var0, long var2, int var4, long[] var5, long var6);

    public static native long mkFreshConst(long var0, String var2, long var3);

    public static native long mkFreshFuncDecl(long var0, String var2, int var3, long[] var4, long var5);

    public static native long mkTrue(long var0);

    public static native long mkFalse(long var0);

    public static native long mkEq(long var0, long var2, long var4);

    public static native long mkDistinct(long var0, int var2, long[] var3);

    public static native long mkNot(long var0, long var2);

    public static native long mkITE(long var0, long var2, long var4, long var6);

    public static native long mkIff(long var0, long var2, long var4);

    public static native long mkImplies(long var0, long var2, long var4);

    public static native long mkXor(long var0, long var2, long var4);

    public static native long mkAnd(long var0, int var2, long[] var3);

    public static native long mkOr(long var0, int var2, long[] var3);

    public static native long mkAdd(long var0, int var2, long[] var3);

    public static native long mkMul(long var0, int var2, long[] var3);

    public static native long mkSub(long var0, int var2, long[] var3);

    public static native long mkUnaryMinus(long var0, long var2);

    public static native long mkDiv(long var0, long var2, long var4);

    public static native long mkDiv2(long var0, long var2, long var4);

    public static native long mkMod(long var0, long var2, long var4);

    public static native long mkRem(long var0, long var2, long var4);

    public static native long mkPower(long var0, long var2, long var4);

    public static native long mkLT(long var0, long var2, long var4);

    public static native long mkLE(long var0, long var2, long var4);

    public static native long mkGT(long var0, long var2, long var4);

    public static native long mkGE(long var0, long var2, long var4);

    public static native long mkInt2Real(long var0, long var2);

    public static native long mkReal2Int(long var0, long var2);

    public static native long mkIsInt(long var0, long var2);

    public static native long mkArraySort(long var0, long var2, long var4);

    public static native long mkSelect(long var0, long var2, long var4);

    public static native long mkStore(long var0, long var2, long var4, long var6);

    public static native long mkConstArray(long var0, long var2, long var4);

    public static native long mkArrayDefault(long var0, long var2);

    public static native long mkTupleSort(long var0, long var2, int var4, long[] var5, long[] var6, Pointer var7, long[] var8);

    public static native long mkSetSort(long var0, long var2);

    public static native long mkEmptySet(long var0, long var2);

    public static native long mkFullSet(long var0, long var2);

    public static native long mkSetAdd(long var0, long var2, long var4);

    public static native long mkSetDel(long var0, long var2, long var4);

    public static native long mkSetUnion(long var0, int var2, long[] var3);

    public static native long mkSetIntersect(long var0, int var2, long[] var3);

    public static native long mkSetDifference(long var0, long var2, long var4);

    public static native long mkSetComplement(long var0, long var2);

    public static native long mkSetMember(long var0, long var2, long var4);

    public static native long mkSetSubset(long var0, long var2, long var4);

    public static native long mkInt(long var0, int var2, long var3);

    public static native long mkReal(long var0, int var2, int var3);

    public static native long mkNumeral(long var0, String var2, long var3);

    public static native long mkPattern(long var0, int var2, long[] var3);

    public static native long mkBound(long var0, int var2, long var3);

    public static native long mkQuantifier(long var0, boolean var2, int var3, int var4, long[] var5, int var6, long[] var7, long[] var8, long var9);

    public static native long mkQuantifierConst(long var0, boolean var2, int var3, int var4, long[] var5, int var6, long[] var7, long var8);

    public static native long mkBVSort(long var0, int var2);

    public static native long mkBVNot(long var0, long var2);

    public static native long mkBVRedAnd(long var0, long var2);

    public static native long mkBVRedOr(long var0, long var2);

    public static native long mkBVAnd(long var0, long var2, long var4);

    public static native long mkBVOr(long var0, long var2, long var4);

    public static native long mkBVXor(long var0, long var2, long var4);

    public static native long mkBVNand(long var0, long var2, long var4);

    public static native long mkBVNor(long var0, long var2, long var4);

    public static native long mkBVXnor(long var0, long var2, long var4);

    public static native long mkBVNeg(long var0, long var2);

    public static native long mkBVAdd(long var0, long var2, long var4);

    public static native long mkBVSub(long var0, long var2, long var4);

    public static native long mkBVMul(long var0, long var2, long var4);

    public static native long mkBVUdiv(long var0, long var2, long var4);

    public static native long mkBVSdiv(long var0, long var2, long var4);

    public static native long mkBVUrem(long var0, long var2, long var4);

    public static native long mkBVSrem(long var0, long var2, long var4);

    public static native long mkBVSmod(long var0, long var2, long var4);

    public static native long mkBVUlt(long var0, long var2, long var4);

    public static native long mkBVSlt(long var0, long var2, long var4);

    public static native long mkBVUle(long var0, long var2, long var4);

    public static native long mkBVSle(long var0, long var2, long var4);

    public static native long mkBVUgt(long var0, long var2, long var4);

    public static native long mkBVSgt(long var0, long var2, long var4);

    public static native long mkBVUge(long var0, long var2, long var4);

    public static native long mkBVSge(long var0, long var2, long var4);

    public static native long mkConcat(long var0, long var2, long var4);

    public static native long mkExtract(long var0, int var2, int var3, long var4);

    public static native long mkSignExt(long var0, int var2, long var3);

    public static native long mkZeroExt(long var0, int var2, long var3);

    public static native long mkRepeat(long var0, int var2, long var3);

    public static native long mkBVShl(long var0, long var2, long var4);

    public static native long mkBVLshr(long var0, long var2, long var4);

    public static native long mkBVAshr(long var0, long var2, long var4);

    public static native long mkRotateLeft(long var0, int var2, long var3);

    public static native long mkRotateRight(long var0, int var2, long var3);

    public static native long mkExtRotateLeft(long var0, long var2, long var4);

    public static native long mkExtRotateRight(long var0, long var2, long var4);

    public static native long mkInt2BV(long var0, int var2, long var3);

    public static native long mkBV2Int(long var0, long var2, boolean var4);

    public static native long mkBVAddNoOverflow(long var0, long var2, long var4, boolean var6);

    public static native long mkBVAddNoUnderflow(long var0, long var2, long var4);

    public static native long mkBVSubNoUnderflow(long var0, long var2, long var4, boolean var6);

    public static native long mkBVSubNoOverflow(long var0, long var2, long var4);

    public static native long mkBVSdivNoOverflow(long var0, long var2, long var4);

    public static native long mkBVNegNoOverflow(long var0, long var2);

    public static native long mkBVMulNoOverflow(long var0, long var2, long var4, boolean var6);

    public static native long mkBVMulNoUnderflow(long var0, long var2, long var4);

    public static native int getBVSortSize(long var0, long var2);

    public static native int getSymbolKind(long var0, long var2);

    public static native int getSymbolInt(long var0, long var2);

    public static native String getSymbolString(long var0, long var2);

    public static native int getASTKind(long var0, long var2);

    public static native int getDeclKind(long var0, long var2);

    public static native long getAppDecl(long var0, long var2);

    public static native int getAppNumArgs(long var0, long var2);

    public static native long getAppArg(long var0, long var2, int var4);

    public static native long getDeclName(long var0, long var2);

    public static native long getDeclFuncDeclParameter(long var0, long var2, int var4);

    public static native long getSort(long var0, long var2);

    public static native int getDomainSize(long var0, long var2);

    public static native long getDomain(long var0, long var2, int var4);

    public static native long getRange(long var0, long var2);

    public static native boolean getNumeralInt(long var0, long var2, IntPtr var4);

    public static native String getNumeralString(long var0, long var2);

    public static native long getNumerator(long var0, long var2);

    public static native long getDenominator(long var0, long var2);

    public static native boolean isAlgebraicNumber(long var0, long var2);

    public static native int getBoolValue(long var0, long var2);

    public static native int getSearchFailure(long var0);

    public static native void delModel(long var0, long var2);

    public static native void modelIncRef(long var0, long var2);

    public static native void modelDecRef(long var0, long var2);

    public static native boolean eval(long var0, long var2, long var4, Pointer var6);

    public static native boolean modelEval(long var0, long var2, long var4, Pointer var6, boolean var7);

    public static native int getModelNumConstants(long var0, long var2);

    public static native long getModelConstant(long var0, long var2, int var4);

    public static native boolean isArrayValue(long var0, long var2, long var4, IntPtr var6);

    public static native void getArrayValue(long var0, long var2, long var4, int var6, long[] var7, long[] var8, Pointer var9);

    public static native int getModelNumFuncs(long var0, long var2);

    public static native long getModelFuncDecl(long var0, long var2, int var4);

    public static native int getModelFuncNumEntries(long var0, long var2, int var4);

    public static native int getModelFuncEntryNumArgs(long var0, long var2, int var4, int var5);

    public static native long getModelFuncEntryArg(long var0, long var2, int var4, int var5, int var6);

    public static native long getModelFuncEntryValue(long var0, long var2, int var4, int var5);

    public static native long getModelFuncElse(long var0, long var2, int var4);

    public static native long mkLabel(long var0, long var2, boolean var4, long var5);

    public static native long getRelevantLabels(long var0);

    public static native long getRelevantLiterals(long var0);

    public static native long getGuessedLiterals(long var0);

    public static native void delLiterals(long var0, long var2);

    public static native int getNumLiterals(long var0, long var2);

    public static native long getLabelSymbol(long var0, long var2, int var4);

    public static native long getLiteral(long var0, long var2, int var4);

    public static native boolean isQuantifierForall(long var0, long var2);

    public static native long getQuantifierBody(long var0, long var2);

    public static native long getQuantifierBoundName(long var0, long var2, int var4);

    public static native int getQuantifierNumBound(long var0, long var2);

    public static native int getIndexValue(long var0, long var2);

    public static native void disableLiteral(long var0, long var2, int var4);

    public static native void blockLiterals(long var0, long var2);

    public static native void printAST(long var0, long var2);

    public static native void printModel(long var0, long var2);

    public static native void printContext(long var0);

    public static native String astToString(long var0, long var2);

    public static native String funcDeclToString(long var0, long var2);

    public static native String sortToString(long var0, long var2);

    public static native String patternToString(long var0, long var2);

    public static native String modelToString(long var0, long var2);

    public static native String contextToString(long var0);

    public static native String benchmarkToSMTLIBString(long var0, String var2, String var3, String var4, String var5, int var6, long[] var7, long var8);

    public static native long mkTheory(long var0, String var2);

    public static native void setTheoryCallbacks(long var0, AbstractTheoryProxy var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11, boolean var12, boolean var13, boolean var14, boolean var15, boolean var16, boolean var17, boolean var18);

    public static native long theoryMkSort(long var0, long var2, long var4);

    public static native long theoryMkValue(long var0, long var2, long var4, long var6);

    public static native long theoryMkConstant(long var0, long var2, long var4, long var6);

    public static native long theoryMkFuncDecl(long var0, long var2, long var4, int var6, long[] var7, long var8);

    public static native void theoryAssertAxiom(long var0, long var2);

    public static native void theoryAssumeEq(long var0, long var2, long var4);

    public static native void theoryEnableAxiomSimplification(long var0, boolean var2);

    public static native long theoryGetEqCRoot(long var0, long var2);

    public static native long theoryGetEqCNext(long var0, long var2);

    public static native int theoryGetNumParents(long var0, long var2);

    public static native long theoryGetParent(long var0, long var2, int var4);

    public static native boolean theoryIsValue(long var0, long var2);

    public static native boolean theoryIsDecl(long var0, long var2);

    public static native int theoryGetNumElems(long var0);

    public static native long theoryGetElem(long var0, int var2);

    public static native int theoryGetNumApps(long var0);

    public static native long theoryGetApp(long var0, int var2);

    public static native void parseSMTLIBString(long var0, String var2, int var3, long[] var4, long[] var5, int var6, long[] var7, long[] var8);

    public static native void parseSMTLIBFile(long var0, String var2, int var3, long[] var4, long[] var5, int var6, long[] var7, long[] var8);

    public static native long parseSMTLIB2String(long var0, String var2, int var3, long[] var4, long[] var5, int var6, long[] var7, long[] var8);

    public static native long parseSMTLIB2File(long var0, String var2, int var3, long[] var4, long[] var5, int var6, long[] var7, long[] var8);

    public static native int getSMTLIBNumFormulas(long var0);

    public static native long getSMTLIBFormula(long var0, int var2);

    public static native int getSMTLIBNumAssumptions(long var0);

    public static native long getSMTLIBAssumption(long var0, int var2);

    public static native int getSMTLIBNumDecls(long var0);

    public static native long getSMTLIBDecl(long var0, int var2);

    public static native int getSMTLIBNumSorts(long var0);

    public static native long getSMTLIBSort(long var0, int var2);

    public static native String getSMTLIBError(long var0);

    public static native long substitute(long var0, long var2, int var4, long[] var5, long[] var6);

    public static native void setAstPrintMode(long var0, int var2);

    public static native long simplify(long var0, long var2);

    public static native long mkTactic(long var0, String var2);

    public static native long tacticAndThen(long var0, long var2, long var4);

    public static native long mkSolver(long var0);

    public static native long mkSolverFromTactic(long var0, long var2);

    public static native void tacticIncRef(long var0, long var2);

    public static native void tacticDecRef(long var0, long var2);

    public static native void solverPush(long var0, long var2);

    public static native void solverPop(long var0, long var2, int var4);

    public static native void solverAssertCnstr(long var0, long var2, long var4);

    public static native void solverReset(long var0, long var2);

    public static native int solverCheck(long var0, long var2);

    public static native long solverGetModel(long var0, long var2);

    public static native long solverGetProof(long var0, long var2);

    public static native void solverIncRef(long var0, long var2);

    public static native void solverDecRef(long var0, long var2);

    public static native long solverGetAssertions(long var0, long var2);

    public static native long solverGetUnsatCore(long var0, long var2);

    public static native int solverGetNumScopes(long var0, long var2);

    public static native int solverCheckAssumptions(long var0, long var2, int var4, long[] var5);

    public static native String solverGetReasonUnknown(long var0, long var2);

    public static native String solverToString(long var0, long var2);

    public static native void astvectorIncRef(long var0, long var2);

    public static native void astvectorDecRef(long var0, long var2);

    public static native int astvectorSize(long var0, long var2);

    public static native long astvectorGet(long var0, long var2, int var4);

    public static native void astvectorSet(long var0, long var2, int var4, long var5);

    public static native void getVersion(IntPtr var0, IntPtr var1, IntPtr var2, IntPtr var3);

    public static native void resetMemory();

    public static native void push(long var0);

    public static native void pop(long var0, int var2);

    public static native int getNumScopes(long var0);

    public static native void assertCnstr(long var0, long var2);

    public static native int check(long var0);

    public static native int checkAndGetModel(long var0, Pointer var2);

    public static native int checkAssumptions(long var0, int var2, long[] var3, Pointer var4, int var5, IntPtr var6, long[] var7);

    static {
        if (!Z3Wrapper.withinJar()) {
            System.err.println("It seems you are not running ScalaZ3 from its JAR");
            System.exit(1);
        }
        Z3Wrapper.loadFromJar();
        ptrToCtx = new HashMap();
        tpmap = new HashMap();
    }

    public static class IntPtr {
        public int value;
    }
}

